/*
 * Decompiled with CFR 0.152.
 */
package Graphing;

import Data.XY;
import GUIModule.ColorGradient;
import Graphing.GraphIterable;
import Graphing.GraphIterables;
import Util.UtilGraphics;
import Util.UtilMath;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JPanel;

public class GraphPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private GraphIterables iterables;
    private String topLeftText = "";
    private String topRightText = "";
    private double plotXMin = -1.0;
    private double plotXMax = 1.0;
    private double plotYMin = -1.0;
    private double plotYMax = 1.0;
    private int pointRadius = 5;
    private boolean plotPoint = false;
    private boolean plotLine = false;
    private boolean plotBar = true;
    private boolean useDynamicColor = true;
    private String plotBarFormat = "%.0f";
    private Color topLeftTextColor = Color.WHITE;
    private Color topRightTextColor = Color.white;
    private Font font = new Font("ARIAL", 0, 16);
    private static final int marginTop = 0;
    private static final int marginBottom = 16;

    public GraphPanel() {
        this.setBackground(Color.BLACK);
    }

    public void setTopLeftTextColor(Color color) {
        this.topLeftTextColor = color;
    }

    public void setTopRightTextColor(Color color) {
        this.topRightTextColor = color;
    }

    public void setIterables(GraphIterables iterables) {
        this.iterables = iterables;
    }

    public GraphIterables getGraphIterables() {
        return this.iterables;
    }

    public void setPlotMinMaxX(double plotXMin, double plotXMax) {
        this.plotXMin = plotXMin;
        this.plotXMax = plotXMax;
    }

    public void setPlotMinMaxY(double plotYMin, double plotYMax) {
        this.plotYMin = plotYMin;
        this.plotYMax = plotYMax;
    }

    public void setPlotPoint(boolean value) {
        this.plotPoint = value;
    }

    public void setPlotBarFormat(String barFormat) {
        this.plotBarFormat = barFormat;
    }

    public String getPlotBarFormat() {
        return this.plotBarFormat;
    }

    public boolean getPlotPoint() {
        return this.plotPoint;
    }

    public void setDynamicColor(boolean value) {
        this.useDynamicColor = value;
    }

    public boolean getDynamicColor() {
        return this.useDynamicColor;
    }

    public void setPointRadius(int pointRadius) {
        this.pointRadius = pointRadius;
    }

    public int getPointRadius() {
        return this.pointRadius;
    }

    public void setPlotLine(boolean value) {
        this.plotLine = value;
    }

    public boolean getPlotLine() {
        return this.plotLine;
    }

    private boolean isOutOfBound(XY xy) {
        double x = xy.getX();
        double y = xy.getY();
        return x < this.plotXMin || this.plotXMax < x || y < this.plotYMin || this.plotYMax < y;
    }

    private boolean isOutOfBoundX(XY xy) {
        double x = xy.getX();
        return x < this.plotXMin || this.plotXMax < x;
    }

    private int getPixelX(double x) {
        int w = this.getWidth();
        return UtilMath.mapToInt(x, this.plotXMin, this.plotXMax, 0.0, w);
    }

    private int getPixelY(double y) {
        int h = this.getHeight();
        return 0 + UtilMath.mapToInt(y, this.plotYMin, this.plotYMax, h - 0 - 16, 0.0);
    }

    private void drawIterable(Graphics g, GraphIterable iterable, int w, int h) {
        ColorGradient gradient = ColorGradient.getRainbowScheme(128);
        if (this.plotLine) {
            g.setColor(iterable.getColor().darker());
            XY xy0 = null;
            XY xy1 = null;
            for (XY xy : iterable) {
                xy0 = xy1;
                xy1 = xy;
                if (xy0 == null || xy1 == null || this.isOutOfBound(xy0) && this.isOutOfBound(xy1)) continue;
                int px0 = this.getPixelX(xy0.getX());
                int px1 = this.getPixelX(xy1.getX());
                int py0 = this.getPixelY(xy0.getY());
                int py1 = this.getPixelY(xy1.getY());
                if (this.useDynamicColor) {
                    g.setColor(new Color(gradient.getARGB(UtilMath.map((xy0.getY() + xy1.getY()) / 2.0, this.plotYMin, this.plotYMax, 0.0, 1.0))));
                }
                g.drawLine(px0, py0, px1, py1);
            }
        }
        if (this.plotBar) {
            g.setFont(new Font("ARIAL", 0, 12));
            g.setColor(iterable.getColor());
            for (XY xy : iterable) {
                if (this.isOutOfBoundX(xy)) continue;
                int px = this.getPixelX(xy.getX());
                int py = this.getPixelY(xy.getY());
                if (this.useDynamicColor) {
                    g.setColor(new Color(gradient.getARGB(UtilMath.map(xy.getY(), this.plotYMin, this.plotYMax, 0.0, 1.0))));
                }
                UtilGraphics.fillRect(g, px - this.pointRadius, py, 2 * this.pointRadius + 1, h - 16 - py);
                g.setColor(g.getColor().brighter().brighter());
                String barText = String.format(this.plotBarFormat, xy.getY());
                g.drawString(barText, px - g.getFontMetrics().stringWidth(barText) / 2, h - 16 + g.getFont().getSize());
            }
        }
        if (this.plotPoint) {
            g.setColor(iterable.getColor());
            for (XY xy : iterable) {
                if (this.isOutOfBound(xy)) continue;
                int px = this.getPixelX(xy.getX());
                int py = this.getPixelY(xy.getY());
                if (this.useDynamicColor) {
                    g.setColor(new Color(gradient.getARGB(UtilMath.map(xy.getY(), this.plotYMin, this.plotYMax, 0.0, 1.0))));
                }
                UtilGraphics.fillCenteredSquare(g, px, py, this.pointRadius);
            }
        }
        g.setFont(this.font);
        int fontSize = g.getFont().getSize();
        g.setColor(this.topLeftTextColor);
        g.drawString(this.topLeftText, 5, fontSize);
        g.setColor(this.topRightTextColor);
        g.drawString(this.topRightText, w - 5 - g.getFontMetrics().stringWidth(this.topRightText), fontSize);
    }

    private void drawIterables(Graphics g, int w, int h) {
        if (this.iterables == null) {
            return;
        }
        for (GraphIterable iterable : this.iterables) {
            this.drawIterable(g, iterable, w, h);
        }
    }

    private void drawFrame(Graphics g, int w, int h) {
        g.setColor(Color.DARK_GRAY);
        g.drawLine(0, 0, w, 0);
        g.drawLine(0, h - 16, w, h - 16);
        g.drawLine(0, 0, w, 0);
        g.drawLine(0, h, w, h);
        g.drawLine(0, 0, 0, h);
        g.drawLine(w, 0, w, h);
    }

    public void draw(Graphics g, int w, int h) {
        this.drawIterables(g, w, h);
        this.drawFrame(g, w, h);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.draw(g, this.getWidth(), this.getHeight());
    }

    public void setTopLeftText(String text) {
        this.topLeftText = text;
    }

    public void setTopRightText(String text) {
        this.topRightText = text;
    }
}

