/*
 * Decompiled with CFR 0.152.
 */
package Graphing;

import Data.XY;
import Graphing.GraphIterable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class GraphQueue
extends GraphIterable {
    private Queue<XY> queue = new LinkedList<XY>();

    @Override
    public Iterator<XY> iterator() {
        return this.queue.iterator();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public void add(XY xy) {
        this.queue.add(xy);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public double getXMin() {
        double xMin = 0.0;
        for (XY xy : this) {
            double x = xy.getX();
            double d = xMin = x < xMin || this.size() == 0 ? x : xMin;
        }
        return xMin;
    }

    @Override
    public double getYMin() {
        double yMin = 0.0;
        for (XY xy : this) {
            double y = xy.getY();
            double d = yMin = y < yMin || this.size() == 0 ? y : yMin;
        }
        return yMin;
    }

    @Override
    public double getXMax() {
        double xMax = 0.0;
        for (XY xy : this) {
            double x = xy.getX();
            double d = xMax = x < xMax || this.size() == 0 ? x : xMax;
        }
        return xMax;
    }

    @Override
    public double getYMax() {
        double yMax = 0.0;
        for (XY xy : this) {
            double y = xy.getY();
            double d = yMax = y < yMax || this.size() == 0 ? y : yMax;
        }
        return yMax;
    }

    public XY peek() {
        return this.queue.peek();
    }

    public XY poll() {
        return this.queue.poll();
    }
}

