/*
 * Decompiled with CFR 0.152.
 */
package Map;

import GUIModule.ColorGradient;
import Util.UtilMath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;

public class BarPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static Color EMPTY_COLOR = new Color(32, 32, 32);
    private static int marginBottom = 16;
    private double min;
    private double max;
    private boolean valueAvailable;
    private double value;
    private long lastUpdateTime;
    private int animationLevel;

    public BarPanel() {
        this.setBackground(Color.BLACK);
        this.setPreferredSize(new Dimension(16, 1));
    }

    public void setValue(double value) {
        this.lastUpdateTime = System.currentTimeMillis();
        this.valueAvailable = true;
        this.value = value;
        this.animationLevel = 16;
    }

    public void clear() {
        this.valueAvailable = false;
    }

    public void setMinMax(double min, double max) {
        this.min = min;
        this.max = max;
    }

    private static int IMR(double x) {
        return (int)Math.round(x);
    }

    @Override
    public void paint(Graphics g) {
        ColorGradient gradient = ColorGradient.getRainbowScheme(64);
        super.paint(g);
        int w = this.getWidth();
        int h = this.getHeight();
        int slotCount = 10;
        double slotHeight = (double)(h - marginBottom) / (double)slotCount;
        g.setColor(EMPTY_COLOR);
        Color fullColor = new Color(gradient.getARGB(UtilMath.map(this.value, this.min, this.max, 0.0, 1.0)));
        int maxFullIndex = BarPanel.IMR(UtilMath.map(this.value, this.min, this.max, 0.0, slotCount - 1));
        int i = 0;
        while (i < slotCount) {
            Color color = this.valueAvailable && i >= slotCount - 1 - maxFullIndex ? fullColor : EMPTY_COLOR;
            g.setColor(color);
            double y = (double)i * slotHeight;
            g.fillOval(0, BarPanel.IMR(y + 1.0), BarPanel.IMR(slotHeight), BarPanel.IMR(slotHeight - 2.0));
            g.fillOval(BarPanel.IMR((double)w - slotHeight), BarPanel.IMR(y + 1.0), BarPanel.IMR(slotHeight), BarPanel.IMR(slotHeight - 2.0));
            g.fillRect(BarPanel.IMR(slotHeight / 2.0), BarPanel.IMR(y + 1.0), BarPanel.IMR((double)w - slotHeight), BarPanel.IMR(slotHeight - 2.0));
            ++i;
        }
        g.setColor(Color.DARK_GRAY);
        g.drawLine(0, h - marginBottom, w, h - marginBottom);
        g.drawLine(0, h, w, h);
        if (this.animationLevel > 0) {
            this.animationLevel = (int)Math.max(0L, 16L - (System.currentTimeMillis() - this.lastUpdateTime >> 4));
            int r = 16 - this.animationLevel;
            g.setColor(Color.GRAY);
            g.drawOval(w / 2 - r, h - marginBottom + w / 2 - r, 1 + r * 2, 1 + r * 2);
        }
    }
}

