/*
 * Decompiled with CFR 0.152.
 */
package Map;

import GUIModule.ZoomableImageModule.ZoomableImagePanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class MapScalePanel
extends ZoomableImagePanel {
    private static final long serialVersionUID = 1L;
    private int selectionIndex = 0;
    private int[] xs = new int[2];
    private int[] ys = new int[2];

    public MapScalePanel() {
        this.setPreferredSize(new Dimension(800, 800));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                ((MapScalePanel)MapScalePanel.this).xs[((MapScalePanel)MapScalePanel.this).selectionIndex] = (int)Math.round(MapScalePanel.this.getTrueX(event.getX()));
                ((MapScalePanel)MapScalePanel.this).ys[((MapScalePanel)MapScalePanel.this).selectionIndex] = (int)Math.round(MapScalePanel.this.getTrueY(event.getY()));
                MapScalePanel.this.selectionIndex = 1 - MapScalePanel.this.selectionIndex;
                MapScalePanel.this.repaint();
            }
        });
    }

    @Override
    public void setImage(Image image) {
        super.setImage(image);
        int i = 0;
        while (i < 2) {
            this.xs[i] = image.getWidth(null) / 2;
            this.ys[i] = image.getHeight(null) / 2;
            ++i;
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        int radius = 2;
        int diameter = 2 * radius + 1;
        g.setColor(Color.RED);
        g.drawLine(this.xs[0], this.ys[0], this.xs[1], this.ys[1]);
        int i = 0;
        while (i < 2) {
            g.setColor(Color.BLACK);
            g.fillOval(this.xs[i] - radius, this.ys[i] - radius, diameter, diameter);
            g.setColor(i == this.selectionIndex ? Color.RED : Color.DARK_GRAY);
            g.drawOval(this.xs[i] - radius, this.ys[i] - radius, diameter, diameter);
            ++i;
        }
    }

    public void setReferenceLocations(int x0, int y0, int x1, int y1) {
        this.xs[0] = x0;
        this.ys[0] = y0;
        this.xs[1] = x1;
        this.ys[1] = y1;
    }

    public double getDistanceInPixels() {
        double dx = this.xs[0] - this.xs[1];
        double dy = this.ys[0] - this.ys[1];
        return Math.sqrt(dx * dx + dy * dy);
    }

    public int getReferenceX0() {
        return this.xs[0];
    }

    public int getReferenceY0() {
        return this.ys[0];
    }

    public int getReferenceX1() {
        return this.xs[1];
    }

    public int getReferenceY1() {
        return this.ys[1];
    }
}

