/*
 * Decompiled with CFR 0.152.
 */
package Map;

import Map.WebMercatorConverter;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class SatelliteMap {
    private String name;
    private double phi1;
    private double psi1;
    private double phi2;
    private double psi2;
    private BufferedImage image;
    private File imageFile;
    private WebMercatorConverter mercatorConverter;

    private SatelliteMap() {
    }

    public static SatelliteMap load(File file) throws Exception {
        SatelliteMap satelliteMap = new SatelliteMap();
        String fileName = file.getName();
        int extensionIndex = fileName.lastIndexOf(46);
        fileName = fileName.substring(0, extensionIndex);
        satelliteMap.image = ImageIO.read(file);
        if (satelliteMap.image == null) {
            throw new Exception("Image file is corrupted.");
        }
        try {
            satelliteMap.imageFile = file;
            if (fileName.contains("$")) {
                String[] fields = fileName.split("[$]", -1);
                satelliteMap.name = fields[0];
                String[] coordinates = fields[1].split(",", -1);
                double phi1 = Double.parseDouble(coordinates[0]);
                double psi1 = Double.parseDouble(coordinates[1]);
                double phi2 = Double.parseDouble(coordinates[2]);
                double psi2 = Double.parseDouble(coordinates[3]);
                satelliteMap.phi1 = phi1;
                satelliteMap.psi1 = psi1;
                satelliteMap.phi2 = phi2;
                satelliteMap.psi2 = psi2;
                satelliteMap.mercatorConverter = new WebMercatorConverter(phi1, psi1, phi2, psi2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return satelliteMap;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("[SatelliteMap]\n");
        s.append(String.format("NAME         = %s\n", this.name));
        s.append(String.format("TOP-LEFT     = (%s, %s)\n", this.phi1, this.psi1));
        s.append(String.format("BOTTOM-RIGHT = (%s, %s)\n", this.phi2, this.psi2));
        s.append("----------------------------------------------------------------\n");
        return s.toString();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public File getImageFile() {
        return this.imageFile;
    }

    public boolean gpsCoordinateAvailable() {
        return this.phi1 != 0.0 || this.psi1 != 0.0 || this.phi2 != 0.0 || this.psi2 != 0.0;
    }

    public double getPhi1() {
        return this.phi1;
    }

    public double getPsi1() {
        return this.psi1;
    }

    public double getPhi2() {
        return this.phi2;
    }

    public double getPsi2() {
        return this.psi2;
    }

    public WebMercatorConverter getMercatorConverter() {
        return this.mercatorConverter;
    }

    public void setGPSCoordinates(double phi1, double psi1, double phi2, double psi2) {
        this.phi1 = phi1;
        this.psi1 = psi1;
        this.phi2 = phi2;
        this.psi2 = psi2;
        this.mercatorConverter = new WebMercatorConverter(phi1, psi1, phi2, psi2);
    }

    public String getImageFileExtension() {
        return this.imageFile.getName().substring(this.imageFile.getName().lastIndexOf(46) + 1);
    }
}

