/*
 * Decompiled with CFR 0.152.
 */
package Map;

import GUIModule.DynamicTable.DynamicTableEntry;
import java.util.LinkedHashMap;
import java.util.Map;

public class SpatialMeasurementNode
implements DynamicTableEntry {
    private String id;
    public final long timestamp;
    public final int pixelX;
    public final int pixelY;
    public final double ratioX;
    public final double ratioY;
    private boolean latitudeLongitudeAvailable;
    private double latitude;
    private double longitude;
    private boolean distanceAvailable;
    private int distance;
    private Map<String, Object> measurementMap = new LinkedHashMap<String, Object>();

    public SpatialMeasurementNode(long timestamp, int pixelX, int pixelY, double ratioX, double ratioY) {
        this.timestamp = timestamp;
        this.pixelX = pixelX;
        this.pixelY = pixelY;
        this.ratioX = ratioX;
        this.ratioY = ratioY;
    }

    public SpatialMeasurementNode(long timestamp, int pixelX, int pixelY, double ratioX, double ratioY, double latitude, double longitude) {
        this(timestamp, pixelX, pixelY, ratioX, ratioY);
        this.latitudeLongitudeAvailable = true;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public void setID(String id) {
        this.id = id;
    }

    public void add(String key, Object value) {
        this.measurementMap.put(key, value);
    }

    public boolean has(String key) {
        return this.measurementMap.containsKey(key) && this.measurementMap.get(key) != null;
    }

    public double get(String key) {
        return ((Number)this.measurementMap.get(key)).doubleValue();
    }

    public boolean dataIsEmpty() {
        return this.measurementMap.isEmpty();
    }

    public String getDistanceAsString() {
        return this.distanceAvailable ? Integer.toString(this.distance) : "";
    }

    @Override
    public Object[] toArray() {
        int n = 8 + this.measurementMap.keySet().size();
        if (this.id != null) {
            ++n;
        }
        Object[] array = new Object[n];
        int i = 0;
        array[i++] = this.timestamp;
        if (this.id != null) {
            array[i++] = this.id;
        }
        array[i++] = this.pixelX;
        array[i++] = this.pixelY;
        array[i++] = String.format("%.6f", this.ratioX);
        array[i++] = String.format("%.6f", this.ratioY);
        array[i++] = this.latitudeLongitudeAvailable ? String.format("%.6f", this.latitude) : null;
        array[i++] = this.latitudeLongitudeAvailable ? String.format("%.6f", this.longitude) : null;
        array[i++] = this.distanceAvailable ? Integer.valueOf(this.distance) : null;
        for (Object value : this.measurementMap.values()) {
            array[i++] = value;
        }
        return array;
    }

    public String coordinateAsCSV() {
        StringBuffer s = new StringBuffer();
        s.append(this.timestamp);
        if (this.id != null) {
            s.append(',');
            s.append(this.id);
        }
        s.append(',');
        s.append(this.pixelX);
        s.append(',');
        s.append(this.pixelY);
        s.append(',');
        s.append(this.ratioX);
        s.append(',');
        s.append(this.ratioY);
        s.append(',');
        s.append(this.latitudeLongitudeAvailable ? Double.valueOf(this.latitude) : "");
        s.append(',');
        s.append(this.latitudeLongitudeAvailable ? Double.valueOf(this.longitude) : "");
        return s.toString();
    }

    public String dataAsMultiCSV() {
        StringBuffer s = new StringBuffer();
        for (String key : this.measurementMap.keySet()) {
            Object value = this.measurementMap.get(key);
            if (value == null) continue;
            s.append('\n');
            s.append(this.timestamp);
            s.append(',');
            s.append(key);
            s.append(',');
            s.append(value);
            s.append(',');
            s.append(this.pixelX);
            s.append(',');
            s.append(this.pixelY);
        }
        String csvs = s.toString();
        return csvs.isEmpty() ? "" : csvs.substring(1);
    }

    public String asSingleLineCombinedCSV() {
        StringBuffer s = new StringBuffer();
        s.append(this.timestamp);
        if (this.id != null) {
            s.append(',');
            s.append(this.id);
        }
        s.append(',');
        s.append(this.pixelX);
        s.append(',');
        s.append(this.pixelY);
        s.append(',');
        s.append(this.ratioX);
        s.append(',');
        s.append(this.ratioY);
        s.append(',');
        s.append(this.latitudeLongitudeAvailable ? Double.valueOf(this.latitude) : "");
        s.append(',');
        s.append(this.latitudeLongitudeAvailable ? Double.valueOf(this.longitude) : "");
        s.append(',');
        s.append(this.distanceAvailable ? Integer.valueOf(this.distance) : "");
        for (String key : this.measurementMap.keySet()) {
            Object value = this.measurementMap.get(key);
            s.append(',');
            s.append(value == null ? "" : value.toString());
        }
        return s.toString();
    }

    public void setDistance(int distanceInMeter) {
        this.distanceAvailable = true;
        this.distance = distanceInMeter;
    }

    public void updateLatitudeLongitude(double phi, double psi) {
        this.latitudeLongitudeAvailable = true;
        this.latitude = phi;
        this.longitude = psi;
    }
}

