/*
 * Decompiled with CFR 0.152.
 */
package Server.AP;

import Main.Encryption;
import Server.AP.SWiSSAPServerConfig;
import Server._Common.Client;
import Server._Common.Execution;
import Server._Common.GPSData;
import Server._Common.TCPServer;
import Util.UtilSystem;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;

public class SWiSSAPServer
extends TCPServer {
    private SWiSSAPServerConfig config;
    private Object lockCliApp = new Object();
    private GPSData gpsData = new GPSData();

    public SWiSSAPServer(SWiSSAPServerConfig config) {
        super(config.port());
        this.config = config;
    }

    private Thread updateAsynchronouslyForever(Runnable runnable) {
        return UtilSystem.startThread(() -> {
            while (true) {
                try {
                    while (true) {
                        runnable.run();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    UtilSystem.sleep(1000);
                    continue;
                }
                break;
            }
        });
    }

    @Override
    public void preStart() {
        if (this.config.gpsEnabled()) {
            String gpsPath = this.config.gpsPath();
            this.updateAsynchronouslyForever(() -> GPSData.updateGPS(gpsPath, this.gpsData));
        }
    }

    private void resetIperf3Server(int port) {
        System.out.printf("[RESET IPERF3] %s\n", port);
        String psCommand = "ps -ef";
        Execution executionPS = new Execution(psCommand);
        String outputPS = new String(executionPS.stdout());
        String[] linesPS = outputPS.split("\n");
        int pid = -1;
        String[] stringArray = linesPS;
        int n = linesPS.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).contains("iperf3") && line.contains("-p " + port)) {
                String[] fieldsPS = line.split("\\s+");
                pid = Integer.parseInt(fieldsPS[0]);
                break;
            }
            ++n2;
        }
        if (pid == -1) {
            System.out.println("[MESSAGE] iperf3 PID undetected.");
        } else {
            String iperf3KillCommand = "sudo kill " + pid;
            Execution executionKillIperf = new Execution(iperf3KillCommand);
            executionKillIperf.run();
            UtilSystem.sleep(1000);
        }
        String iperf3StartCommand = String.format("iperf3 -s -p %d &", port);
        System.out.println("[MESSAGE] " + iperf3StartCommand);
        Execution executionIperf3Start = new Execution(iperf3StartCommand);
        executionIperf3Start.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getStatus(JsonObject buf) {
        JsonObject status = new JsonObject();
        String cli_app_path = "/home/pi/nrc_pkg/script/cli_app";
        status.addProperty("ifconfig", Execution.executeAndGetSTDOUTAsString("ifconfig"));
        Object object = this.lockCliApp;
        synchronized (object) {
            status.addProperty("cli_app(config)", Execution.executeAndGetSTDOUTAsString(String.valueOf(cli_app_path) + " show config"));
            status.addProperty("cli_app(uinfo)", Execution.executeAndGetSTDOUTAsString(String.valueOf(cli_app_path) + " show uinfo 0"));
        }
        buf.add("status", status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRSSISNR(JsonObject buf, String macAddress) {
        String[] lines;
        macAddress = macAddress.toLowerCase();
        String command = "/home/pi/nrc_pkg/script/cli_app show signal";
        String stdout = null;
        Object object = this.lockCliApp;
        synchronized (object) {
            stdout = Execution.executeAndGetSTDOUTAsString(command);
        }
        String[] stringArray = lines = stdout.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).contains(macAddress) && line.contains("rssi") && line.contains("snr")) {
                line = line.substring(line.indexOf("rssi"));
                int rssi = Integer.parseInt(line.substring(line.indexOf(":") + 1, line.indexOf("snr")).trim());
                line = line.substring(line.indexOf("snr"));
                int snr = Integer.parseInt(line.substring(line.indexOf(":") + 1).trim());
                JsonObject resultRSSISNR = new JsonObject();
                resultRSSISNR.addProperty("rssi", rssi);
                resultRSSISNR.addProperty("snr", snr);
                buf.add("rssi_snr", resultRSSISNR);
                return;
            }
            ++n2;
        }
    }

    private int charCount(String text, char c) {
        int n = 0;
        char[] cArray = text.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        while (n3 < n2) {
            char x = cArray[n3];
            if (x == c) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    private List<String> getSTAIPFromARP() {
        String stdout = Execution.executeAndGetSTDOUTAsString("arp");
        String[] lines = stdout.split("\n");
        ArrayList<String> addresses = new ArrayList<String>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            try {
                line = line.trim();
                if (!line.isEmpty()) {
                    String[] fields = line.split("\\s+");
                    String ip = fields[0];
                    String mac = fields[2];
                    String interfaceName = fields[fields.length - 1];
                    if (interfaceName.equals(this.config.arpNetworkInterface()) && this.charCount(ip, '.') == 3 && this.charCount(mac, ':') == 5) {
                        addresses.add(String.format("%s/%s", ip, mac));
                    }
                }
            }
            catch (Exception e) {
                System.out.printf("[MESSAGE] ARP line (%s) could not be parsed.\n", line);
            }
            ++n2;
        }
        return addresses;
    }

    private void getSTAInfo(JsonObject buf) {
        JsonObject staInfo = new JsonObject();
        List<String> staAddresses = null;
        staAddresses = this.config.retrieveSTAIPFromARP() ? this.getSTAIPFromARP() : this.config.explicitSTAAddressList();
        int port = this.config.remoteSTAServerPort();
        for (String staAddress : staAddresses) {
            try {
                String[] fields = staAddress.split("/");
                String ip = fields[0];
                Client client = new Client(ip, port);
                String request = Encryption.encodeLine("GET");
                client.writeLine(request);
                String response = Encryption.decodeLine(client.readLine());
                client.close();
                JsonObject entry = JsonParser.parseString(response).getAsJsonObject();
                staInfo.add(staAddress, entry);
            }
            catch (Exception e) {
                System.out.printf("[ERROR] Could not connect to %s.\n", staAddress);
            }
        }
        buf.add("sta_info", staInfo);
    }

    private void getGPSInfo(JsonObject buf) {
        if (this.config.gpsEnabled()) {
            JsonObject gpsInfo = this.gpsData.get();
            buf.add("gps", gpsInfo);
        }
    }

    @Override
    public void handleClientRequest(Client client, String address) {
        try {
            JsonObject res = new JsonObject();
            String line = client.readLine();
            line.trim();
            line = Encryption.decodeLine(line);
            String[] fields = line.split("\\s+");
            String command = fields[0];
            System.out.println(command);
            switch (command) {
                case "IPERF3": {
                    int iperf3Port = Integer.parseInt(fields[1]);
                    this.resetIperf3Server(iperf3Port);
                    break;
                }
                case "RSSI_SNR": {
                    String macAddress = fields[1];
                    this.getRSSISNR(res, macAddress);
                    break;
                }
                case "STA_INFO": {
                    this.getSTAInfo(res);
                    break;
                }
                case "GPS_INFO": {
                    this.getGPSInfo(res);
                    break;
                }
                case "STATUS": {
                    this.getStatus(res);
                    break;
                }
                default: {
                    System.err.printf("[ERROR(%s)] Unknown Command: %s\n", address, command);
                    return;
                }
            }
            System.out.println(res);
            if (res != null) {
                String response = res.toString();
                response = Encryption.encodeLine(response);
                client.writeLine(response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.printf("[ERROR] %s", e.toString());
        }
    }
}

