/*
 * Decompiled with CFR 0.152.
 */
package Server.STA.NRC7394Host;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;

public class SWiSSSTAServerConfig {
    private int port;
    private boolean gpsEnabled;
    private String gpsPath;
    private String remoteIP;
    private int remoteControlServerPort;
    private boolean iperf3Enabled;
    private int iperf3RemotePort;
    private int iperf3Omission;
    private int iperf3Duration;
    private boolean iperf3TCPUplink;
    private boolean iperf3TCPDownlink;
    private boolean iperf3UDPUplink;
    private boolean iperf3UDPDownlink;
    private boolean iperf3RemoteSessionRenewEnabled;
    private boolean localRSSISNREnabled;
    private int localRSSISNRPeriod;
    private boolean remoteRSSISNREnabled;
    private int remoteRSSISNRPeriod;
    private boolean pingEnabled;
    private int pingPeriod;

    public SWiSSSTAServerConfig(File file) throws IOException {
        String text = new String(Files.readAllBytes(file.toPath()));
        JsonObject json = JsonParser.parseString(text).getAsJsonObject();
        for (String key : json.keySet()) {
            System.out.println("KEY=[" + key + "]");
            switch (key) {
                case "SERVER_PORT": {
                    this.port = json.get(key).getAsInt();
                    break;
                }
                case "USE_GPS": {
                    this.gpsEnabled = json.get(key).getAsBoolean();
                    break;
                }
                case "GPS_PATH": {
                    this.gpsPath = json.get(key).getAsString();
                    break;
                }
                case "ENABLE_IPERF": {
                    this.iperf3Enabled = json.get(key).getAsBoolean();
                    break;
                }
                case "ENABLE_LOCAL_RSSI_SNR": {
                    this.localRSSISNREnabled = json.get(key).getAsBoolean();
                    break;
                }
                case "ENABLE_REMOTE_RSSI_SNR": {
                    this.remoteRSSISNREnabled = json.get(key).getAsBoolean();
                    break;
                }
                case "ENABLE_PING": {
                    this.pingEnabled = json.get(key).getAsBoolean();
                    break;
                }
                case "REMOTE_IP": {
                    this.remoteIP = json.get(key).getAsString();
                    break;
                }
                case "REMOTE_CONTROL_SERVER_PORT": {
                    this.remoteControlServerPort = json.get(key).getAsInt();
                    break;
                }
                case "IPERF_REMOTE_PORT": {
                    this.iperf3RemotePort = json.get(key).getAsInt();
                    break;
                }
                case "IPERF_OMISSION": {
                    this.iperf3Omission = json.get(key).getAsInt();
                    break;
                }
                case "IPERF_DURATION": {
                    this.iperf3Duration = json.get(key).getAsInt();
                    break;
                }
                case "IPERF_TCP_UPLINK": {
                    this.iperf3TCPUplink = json.get(key).getAsBoolean();
                    break;
                }
                case "IPERF_TCP_DOWNLINK": {
                    this.iperf3TCPDownlink = json.get(key).getAsBoolean();
                    break;
                }
                case "IPERF_UDP_UPLINK": {
                    this.iperf3UDPUplink = json.get(key).getAsBoolean();
                    break;
                }
                case "IPERF_UDP_DOWNLINK": {
                    this.iperf3UDPDownlink = json.get(key).getAsBoolean();
                    break;
                }
                case "IPERF_REMOTE_SESSION_RENEW": {
                    this.iperf3RemoteSessionRenewEnabled = json.get(key).getAsBoolean();
                    break;
                }
                case "LOCAL_RSSI_SNR_PERIOD": {
                    this.localRSSISNRPeriod = json.get(key).getAsInt();
                    break;
                }
                case "REMOTE_RSSI_SNR_PERIOD": {
                    this.remoteRSSISNRPeriod = json.get(key).getAsInt();
                    break;
                }
                case "PING_PERIOD": {
                    this.pingPeriod = json.get(key).getAsInt();
                    break;
                }
                default: {
                    System.err.printf("[ERROR] Unknown STA configuration parameter: %s\n", key);
                }
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public boolean gpsEnabled() {
        return this.gpsEnabled;
    }

    public String gpsPath() {
        return this.gpsPath;
    }

    public String remoteIP() {
        return this.remoteIP;
    }

    public int remoteControlServerPort() {
        return this.remoteControlServerPort;
    }

    public boolean iperf3Enabled() {
        return this.iperf3Enabled;
    }

    public boolean localRSSISNREnabled() {
        return this.localRSSISNREnabled;
    }

    public boolean remoteRSSISNREnabled() {
        return this.remoteRSSISNREnabled;
    }

    public boolean pingEnabled() {
        return this.pingEnabled;
    }

    public int iperf3RemotePort() {
        return this.iperf3RemotePort;
    }

    public int iperf3Omission() {
        return this.iperf3Omission;
    }

    public int iperf3Duration() {
        return this.iperf3Duration;
    }

    public boolean iperf3TCPUplink() {
        return this.iperf3TCPUplink;
    }

    public boolean iperf3TCPDownlink() {
        return this.iperf3TCPDownlink;
    }

    public boolean iperf3UDPUplink() {
        return this.iperf3UDPUplink;
    }

    public boolean iperf3UDPDownlink() {
        return this.iperf3UDPDownlink;
    }

    public boolean iperf3RemoteSessionRenewEnabled() {
        return this.iperf3RemoteSessionRenewEnabled;
    }

    public int localRSSISNRPeriod() {
        return this.localRSSISNRPeriod;
    }

    public int remoteRSSISNRPeriod() {
        return this.remoteRSSISNRPeriod;
    }

    public int pingPeriod() {
        return this.pingPeriod;
    }
}

