/*
 * Decompiled with CFR 0.152.
 */
package Server._Common;

import Util.UtilSystem;
import com.fazecast.jSerialComm.SerialPort;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;

public class GPSData {
    private long index = -1L;
    private long time;
    private boolean locationAvailable;
    private double latitude;
    private double longitude;
    private int satInView;
    private int satFixed;

    public synchronized void update(double latitude, double longitude) {
        ++this.index;
        this.time = System.currentTimeMillis();
        this.locationAvailable = true;
        this.latitude = latitude;
        this.longitude = longitude;
        System.out.printf("[GPS] %s %s\n", latitude, longitude);
    }

    public synchronized void updateSatInView(int count) {
        this.satInView = count;
        System.out.printf("[SAT] %s %s\n", this.satInView, this.satFixed);
    }

    public synchronized void updateSatFixed(int count) {
        this.satFixed = count;
        System.out.printf("[SAT] %s %s\n", this.satInView, this.satFixed);
    }

    public synchronized JsonObject get() {
        JsonObject res = new JsonObject();
        res.addProperty("index", this.index);
        res.addProperty("time", this.time);
        res.addProperty("elapsed", System.currentTimeMillis() - this.time);
        res.addProperty("latitude", this.locationAvailable ? Double.valueOf(this.latitude) : null);
        res.addProperty("longitude", this.locationAvailable ? Double.valueOf(this.longitude) : null);
        res.addProperty("sat_in_view", this.satInView);
        res.addProperty("sat_fixed", this.satFixed);
        return res;
    }

    public String toString() {
        return this.get().toString();
    }

    public static void updateGPS(String gpsPath, GPSData gps) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(gpsPath));
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                System.out.println(line);
                try {
                    String[] z = line.split(",");
                    if (line.startsWith("$GPGLL")) {
                        String latString = z[1];
                        if (latString.isEmpty()) continue;
                        double latDegree = Double.parseDouble(latString.substring(0, 2));
                        double latMinute = Double.parseDouble(latString.substring(2));
                        String latDirection = z[2];
                        double lat = latDegree + latMinute / 60.0;
                        if (latDirection.equals("S")) {
                            lat = -lat;
                        }
                        String lonString = z[3];
                        double lonDegree = Double.parseDouble(lonString.substring(0, 3));
                        double lonMinute = Double.parseDouble(lonString.substring(3));
                        String lonDirection = z[4];
                        double lon = lonDegree + lonMinute / 60.0;
                        if (lonDirection.equals("W")) {
                            lon = -lon;
                        }
                        gps.update(lat, lon);
                        continue;
                    }
                    if (line.startsWith("$GPGSV")) {
                        int satInView = Integer.parseInt(z[3]);
                        gps.updateSatInView(satInView);
                        continue;
                    }
                    if (!line.startsWith("$GPGSA")) continue;
                    int satFixed = 0;
                    int i = 3;
                    while (i < 15) {
                        if (!z[i].isEmpty()) {
                            ++satFixed;
                        }
                        ++i;
                    }
                    gps.updateSatFixed(satFixed);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            UtilSystem.close(reader);
            UtilSystem.sleep(1000);
        }
    }

    public static void updateGPS(SerialPort serial, GPSData gps) {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(serial.getInputStream()));
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                System.out.println(line);
                try {
                    String[] z = line.split(",");
                    if (line.startsWith("$GPGLL")) {
                        String latString = z[1];
                        if (latString.isEmpty()) continue;
                        double latDegree = Double.parseDouble(latString.substring(0, 2));
                        double latMinute = Double.parseDouble(latString.substring(2));
                        String latDirection = z[2];
                        double lat = latDegree + latMinute / 60.0;
                        if (latDirection.equals("S")) {
                            lat = -lat;
                        }
                        String lonString = z[3];
                        double lonDegree = Double.parseDouble(lonString.substring(0, 3));
                        double lonMinute = Double.parseDouble(lonString.substring(3));
                        String lonDirection = z[4];
                        double lon = lonDegree + lonMinute / 60.0;
                        if (lonDirection.equals("W")) {
                            lon = -lon;
                        }
                        gps.update(lat, lon);
                        continue;
                    }
                    if (line.startsWith("$GPGSV")) {
                        int satInView = Integer.parseInt(z[3]);
                        gps.updateSatInView(satInView);
                        continue;
                    }
                    if (!line.startsWith("$GPGSA")) continue;
                    int satFixed = 0;
                    int i = 3;
                    while (i < 15) {
                        if (!z[i].isEmpty()) {
                            ++satFixed;
                        }
                        ++i;
                    }
                    gps.updateSatFixed(satFixed);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            UtilSystem.close(reader);
            UtilSystem.sleep(1000);
        }
    }
}

